/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.wfdefinition;

import filenet.vw.api.VWException;
import filenet.vw.api.VWLog;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWQueue;
import filenet.vw.api.VWSecurityDomain;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWStepProcessorInfo;
import filenet.vw.api.VWTransferResult;
import filenet.vw.api.VWUserInfo;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.IVWIDMDocument;
import filenet.vw.toolkit.utils.table.VWParticipantItem;
import filenet.vw.toolkit.utils.table.VWQubbleSort;
import java.util.Vector;

public class VWDefaultSessionProxy {
    private static Vector m_vwSessionReferences = null;

    public static boolean checkWorkflowIdentifier(String vwVersion) throws VWException {
        VWSession vwSession = VWDefaultSessionProxy.getSession();
        if (vwSession != null) {
            return vwSession.checkWorkflowIdentifier(vwVersion);
        }
        return false;
    }

    public static VWUserInfo fetchCurrentUserInfo() throws VWException {
        VWSession vwSession = VWDefaultSessionProxy.getSession();
        if (vwSession != null) {
            return vwSession.fetchCurrentUserInfo();
        }
        return null;
    }

    public static VWLog fetchEventLog(String eventLogName) throws VWException {
        VWSession vwSession = VWDefaultSessionProxy.getSession();
        if (vwSession != null) {
            return vwSession.fetchEventLog(eventLogName);
        }
        return null;
    }

    public static VWStepProcessorInfo fetchLaunchStepProcessor(String workflowIdentifier) throws VWException {
        VWSession vwSession = VWDefaultSessionProxy.getSession();
        if (vwSession != null) {
            return vwSession.fetchLaunchStepProcessor(workflowIdentifier);
        }
        return null;
    }

    public static String[] fetchComponentQueueNames() throws VWException {
        String[] queueNames;
        VWSession vwSession = VWDefaultSessionProxy.getSession();
        if (vwSession != null && (queueNames = vwSession.fetchQueueNames(1)) != null && queueNames.length > 0) {
            Vector<String> selectedQueueNames = new Vector<String>();
            for (int i = 0; i < queueNames.length; ++i) {
                VWQueue vwQueue = vwSession.getQueue(queueNames[i]);
                if (vwQueue == null || !vwQueue.getIsConnectorQueue()) continue;
                selectedQueueNames.addElement(queueNames[i]);
            }
            if (selectedQueueNames.size() > 0) {
                Object[] componentQueueNames = new String[selectedQueueNames.size()];
                selectedQueueNames.copyInto(componentQueueNames);
                return componentQueueNames;
            }
        }
        return null;
    }

    public static String[] fetchProcessQueueNames() throws VWException {
        String[] queueNames;
        VWSession vwSession = VWDefaultSessionProxy.getSession();
        if (vwSession != null && (queueNames = vwSession.fetchQueueNames(1)) != null && queueNames.length > 0) {
            Vector<String> selectedQueueNames = new Vector<String>();
            for (int i = 0; i < queueNames.length; ++i) {
                VWQueue vwQueue = vwSession.getQueue(queueNames[i]);
                if (vwQueue == null || vwQueue.getIsConnectorQueue()) continue;
                selectedQueueNames.addElement(queueNames[i]);
            }
            if (selectedQueueNames.size() > 0) {
                Object[] processQueueNames = new String[selectedQueueNames.size()];
                selectedQueueNames.copyInto(processQueueNames);
                return processQueueNames;
            }
        }
        return null;
    }

    public static String[] fetchQueueNames(boolean bIncludeSystem) throws VWException {
        VWSession vwSession = VWDefaultSessionProxy.getSession();
        if (vwSession != null) {
            int nFlags = 3;
            if (bIncludeSystem) {
                nFlags |= 4;
            }
            return vwSession.fetchQueueNames(nFlags);
        }
        return null;
    }

    public static VWStepProcessorInfo fetchStepProcessorInfo(String stepProcessorId) throws VWException {
        VWSession vwSession = VWDefaultSessionProxy.getSession();
        if (vwSession != null) {
            return vwSession.fetchStepProcessorInfo(stepProcessorId);
        }
        return null;
    }

    public static VWStepProcessorInfo[] fetchStepProcessors(int stepProcessorType) throws VWException {
        VWSession vwSession = VWDefaultSessionProxy.getSession();
        if (vwSession != null) {
            return vwSession.fetchStepProcessors(stepProcessorType);
        }
        return null;
    }

    public static String[] fetchUserQueueNames() throws VWException {
        VWSession vwSession = VWDefaultSessionProxy.getSession();
        if (vwSession != null) {
            return vwSession.fetchQueueNames(2);
        }
        return null;
    }

    public static VWQueue getQueue(String queueName) throws VWException {
        VWSession vwSession = VWDefaultSessionProxy.getSession();
        if (vwSession != null) {
            return vwSession.getQueue(queueName);
        }
        return null;
    }

    public static VWSession getSession() {
        return VWDefaultSessionProxy.getLoggedOnSession();
    }

    public static boolean isLoggedOn() {
        return VWDefaultSessionProxy.getSession() != null;
    }

    public static boolean removeSession(VWSession vwSession) {
        if (m_vwSessionReferences != null && m_vwSessionReferences.contains(vwSession)) {
            return m_vwSessionReferences.removeElement(vwSession);
        }
        return false;
    }

    public static void setSession(VWSession vwSession) {
        if (vwSession == null) {
            return;
        }
        if (m_vwSessionReferences == null) {
            m_vwSessionReferences = new Vector();
        }
        VWDefaultSessionProxy.removeSession(vwSession);
        m_vwSessionReferences.addElement(vwSession);
    }

    public static VWTransferResult transfer(VWWorkflowDefinition theWorkflow, IVWIDMDocument vwIDMDocument) throws VWException {
        VWSession vwSession = VWDefaultSessionProxy.getSession();
        if (vwSession != null) {
            return vwSession.transfer(theWorkflow, vwIDMDocument.getCanonicalNameWithVer(), false, false);
        }
        return null;
    }

    public static VWParticipantItem[] getFullParticipantItems(VWParticipant[] participants, boolean bSortResult) throws Exception {
        VWParticipant[] verifiedParticipants = VWDefaultSessionProxy.getFullParticipants(participants, bSortResult);
        return VWDefaultSessionProxy.getParticipantItemsUsingParticipants(verifiedParticipants, false);
    }

    public static VWParticipant[] getFullParticipants(VWParticipant[] participants, boolean bSortResult) throws Exception {
        Object[] resultParticipants = null;
        VWSession vwSession = VWDefaultSessionProxy.getSession();
        if (vwSession == null) {
            return null;
        }
        if (participants != null && participants.length > 0) {
            Vector<String> nameList = new Vector<String>();
            Vector<VWParticipant> verifiedList = new Vector<VWParticipant>();
            for (int i = 0; i < participants.length; ++i) {
                if (participants[i] == null) continue;
                if (participants[i].isVerified()) {
                    verifiedList.addElement(participants[i]);
                    continue;
                }
                String name = participants[i].getParticipantName();
                if (name == null || name.length() <= 0) continue;
                nameList.addElement(participants[i].getParticipantName());
            }
            if (nameList.size() > 0) {
                Object[] names = new String[nameList.size()];
                nameList.copyInto(names);
                VWParticipant[] domainParticipants = vwSession.fetchParticipantsPx(null, (String[])names);
                if (domainParticipants != null) {
                    for (int i = 0; i < domainParticipants.length; ++i) {
                        if (domainParticipants[i] == null) {
                            verifiedList.addElement(new VWParticipant((String)names[i]));
                            continue;
                        }
                        verifiedList.addElement(domainParticipants[i]);
                    }
                }
            }
            if (verifiedList.size() > 0) {
                resultParticipants = new VWParticipant[verifiedList.size()];
                verifiedList.copyInto(resultParticipants);
            }
            if (bSortResult && resultParticipants != null && resultParticipants.length > 0) {
                VWQubbleSort.sort(resultParticipants);
            }
        }
        return resultParticipants;
    }

    public static VWParticipantItem[] getQuotedFullParticipantItems(VWParticipant[] participants, boolean bSortResult) throws Exception {
        Object[] resultParticipants = null;
        VWSession vwSession = VWDefaultSessionProxy.getSession();
        if (vwSession == null) {
            return null;
        }
        if (participants != null && participants.length > 0) {
            Vector<String> participantVector = new Vector<String>();
            Vector<String> workflowGroups = new Vector<String>();
            Vector<VWParticipant> verifiedList = new Vector<VWParticipant>();
            for (int i = 0; i < participants.length; ++i) {
                if (participants[i] == null) continue;
                if (participants[i].isVerified()) {
                    verifiedList.addElement(participants[i]);
                    continue;
                }
                String shortName = participants[i].getParticipantName();
                if (shortName != null && shortName.charAt(0) == '\"') {
                    shortName = shortName.substring(1, shortName.length() - 1);
                    participantVector.addElement(shortName);
                    continue;
                }
                workflowGroups.addElement(shortName);
            }
            if (participantVector.size() > 0) {
                Object[] names = new String[participantVector.size()];
                participantVector.copyInto(names);
                VWParticipant[] domainParticipants = vwSession.fetchParticipantsPx(null, (String[])names);
                if (domainParticipants != null) {
                    for (int i = 0; i < domainParticipants.length; ++i) {
                        if (domainParticipants[i] == null) {
                            verifiedList.addElement(new VWParticipant('\"' + (String)names[i] + '\"'));
                            continue;
                        }
                        String shortName = domainParticipants[i].getParticipantName();
                        if (shortName != null && shortName.charAt(0) != '\"') {
                            shortName = new String('\"' + shortName + '\"');
                        }
                        domainParticipants[i].setParticipantName(shortName);
                        verifiedList.addElement(domainParticipants[i]);
                    }
                }
            }
            Vector<VWParticipantItem> resultList = new Vector<VWParticipantItem>();
            if (verifiedList.size() > 0) {
                for (int i = 0; i < verifiedList.size(); ++i) {
                    resultList.addElement(new VWParticipantItem((VWParticipant)verifiedList.elementAt(i)));
                }
            }
            if (workflowGroups.size() > 0) {
                for (int i = 0; i < workflowGroups.size(); ++i) {
                    resultList.addElement(new VWParticipantItem((String)workflowGroups.elementAt(i), 2));
                }
            }
            if (resultList.size() > 0) {
                resultParticipants = new VWParticipantItem[resultList.size()];
                resultList.copyInto(resultParticipants);
                if (bSortResult && resultParticipants != null && resultParticipants.length > 0) {
                    VWQubbleSort.sort(resultParticipants);
                }
            }
        }
        return resultParticipants;
    }

    public static VWParticipant[] getParticipantsFromParticipantItems(VWParticipantItem[] participantItems, boolean bAddQuotes) {
        VWParticipant[] participants = null;
        if (participantItems != null) {
            participants = new VWParticipant[participantItems.length];
            block3: for (int i = 0; i < participantItems.length; ++i) {
                VWParticipant tempParticipant = participantItems[i].getVWParticipant();
                if (tempParticipant == null) {
                    participants[i] = new VWParticipant(participantItems[i].getShortName());
                    continue;
                }
                participants[i] = (VWParticipant)tempParticipant.clone();
                if (!bAddQuotes) continue;
                switch (participantItems[i].getType()) {
                    case 0: 
                    case 1: {
                        String shortName = participants[i].getParticipantName();
                        if (shortName.length() <= 0 || shortName.charAt(0) == '\"') continue block3;
                        participants[i].setParticipantName('\"' + shortName + '\"');
                        continue block3;
                    }
                }
            }
        }
        return participants;
    }

    public static VWParticipantItem[] getParticipantItemsUsingParticipants(VWParticipant[] vwParticipants, boolean bCheckQuotes) {
        VWParticipantItem[] resultParticipants = null;
        try {
            if (vwParticipants != null && vwParticipants.length > 0) {
                resultParticipants = new VWParticipantItem[vwParticipants.length];
                for (int i = 0; i < vwParticipants.length; ++i) {
                    if (vwParticipants[i] == null) continue;
                    if (bCheckQuotes) {
                        String shortName = vwParticipants[i].getParticipantName();
                        if (shortName != null && shortName.charAt(0) == '\"') {
                            resultParticipants[i] = new VWParticipantItem(vwParticipants[i]);
                            continue;
                        }
                        resultParticipants[i] = new VWParticipantItem(shortName, 2);
                        continue;
                    }
                    resultParticipants[i] = new VWParticipantItem(vwParticipants[i]);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return resultParticipants;
    }

    public static VWParticipant fetchGroup(String domainName, String groupName) {
        try {
            String[] names;
            VWParticipant[] participants;
            VWSession vwSession = VWDefaultSessionProxy.getSession();
            if (vwSession != null && (participants = vwSession.fetchParticipantsPx(domainName, names = new String[]{groupName})) != null && participants.length > 0) {
                return participants[0];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String getDefaultSecurityDomainName() throws Exception {
        VWSecurityDomain secDomain;
        VWSession vwSession = VWDefaultSessionProxy.getSession();
        if (vwSession != null && (secDomain = vwSession.getDefaultSecurityDomain()) != null) {
            return secDomain.getDomainName();
        }
        return null;
    }

    private static VWSession getLoggedOnSession() {
        try {
            if (m_vwSessionReferences != null) {
                for (int nIndex = m_vwSessionReferences.size() - 1; nIndex >= 0; --nIndex) {
                    VWSession vwSession = (VWSession)m_vwSessionReferences.elementAt(nIndex);
                    if (vwSession != null && vwSession.isLoggedOn()) {
                        return vwSession;
                    }
                    m_vwSessionReferences.removeElementAt(nIndex);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }
}

